// Generated by CoffeeScript 1.8.0
(function() {
  var addExclusionRule, generateDefaultPattern, onChange, originalPassKeys, originalPattern, originalRule, removeExclusionRule, reset, showMessage;

  originalRule = void 0;

  originalPattern = void 0;

  originalPassKeys = void 0;

  generateDefaultPattern = function(url) {
    if (/^https?:\/\/./.test(url)) {
      return "https?:/" + url.split("/", 3).slice(1).join("/") + "/*";
    } else if (/^[a-z]{3,}:\/\/./.test(url)) {
      return url.split("/", 3).join("/") + "/*";
    } else {
      return url + "*";
    }
  };

  reset = function(initialize) {
    if (initialize == null) {
      initialize = false;
    }
    document.getElementById("optionsLink").setAttribute("href", chrome.runtime.getURL("pages/options.html"));
    return chrome.tabs.getSelected(null, function(tab) {
      var element, isEnabled, passKeysElement, patternElement, _i, _len, _ref;
      isEnabled = chrome.extension.getBackgroundPage().isEnabledForUrl({
        url: tab.url
      });
      if (isEnabled.rule) {
        originalRule = isEnabled.rule;
        originalPattern = originalRule.pattern;
        originalPassKeys = originalRule.passKeys;
      } else {
        originalRule = null;
        originalPattern = generateDefaultPattern(tab.url);
        originalPassKeys = "";
      }
      patternElement = document.getElementById("popupPattern");
      passKeysElement = document.getElementById("popupPassKeys");
      patternElement.value = originalPattern;
      passKeysElement.value = originalPassKeys;
      if (initialize) {
        _ref = [patternElement, passKeysElement];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          element = _ref[_i];
          element.addEventListener("keyup", function(event) {
            if (event.ctrlKey && event.keyCode === 13) {
              addExclusionRule();
              return window.close();
            }
          });
          element.addEventListener("focus", function() {
            return document.getElementById("helpText").style.display = "block";
          });
          element.addEventListener("blur", function() {
            return document.getElementById("helpText").style.display = "none";
          });
        }
        passKeysElement.focus();
        passKeysElement.setSelectionRange(passKeysElement.value.length, passKeysElement.value.length);
      }
      return onChange();
    });
  };

  onChange = function() {
    var passKeys, pattern, popupExclude;
    pattern = document.getElementById("popupPattern").value.trim();
    passKeys = document.getElementById("popupPassKeys").value.trim();
    popupExclude = document.getElementById("popupExclude");
    document.getElementById("popupRemove").disabled = !(originalRule && pattern === originalPattern);
    if (originalRule && pattern === originalPattern && passKeys === originalPassKeys) {
      popupExclude.disabled = true;
      return popupExclude.value = "更新规则";
    } else if (originalRule && pattern === originalPattern) {
      popupExclude.disabled = false;
      return popupExclude.value = "更新规则";
    } else if (originalRule) {
      popupExclude.disabled = false;
      return popupExclude.value = "添加规则";
    } else if (pattern) {
      popupExclude.disabled = false;
      return popupExclude.value = "添加规则";
    } else {
      popupExclude.disabled = true;
      return popupExclude.value = "添加规则";
    }
  };

  showMessage = (function() {
    var hideConfirmationMessage, timer;
    timer = null;
    hideConfirmationMessage = function() {
      document.getElementById("confirmationMessage").setAttribute("style", "display: none");
      return timer = null;
    };
    return function(message) {
      document.getElementById("confirmationMessage").setAttribute("style", "display: inline-block");
      document.getElementById("confirmationMessage").innerHTML = message;
      if (timer) {
        clearTimeout(timer);
      }
      return timer = setTimeout(hideConfirmationMessage, 2000);
    };
  })();

  addExclusionRule = function() {
    var passKeys, pattern;
    pattern = document.getElementById("popupPattern").value.trim();
    passKeys = document.getElementById("popupPassKeys").value.trim();
    chrome.extension.getBackgroundPage().addExclusionRule(pattern, passKeys);
    showMessage("已更新");
    return reset();
  };

  removeExclusionRule = function() {
    var pattern;
    pattern = document.getElementById("popupPattern").value.trim();
    chrome.extension.getBackgroundPage().removeExclusionRule(pattern);
    showMessage("已移除");
    return reset();
  };

  document.addEventListener("DOMContentLoaded", function() {
    var event, field, _i, _j, _len, _len1, _ref, _ref1;
    document.getElementById("popupExclude").addEventListener("click", addExclusionRule, false);
    document.getElementById("popupRemove").addEventListener("click", removeExclusionRule, false);
    _ref = ["popupPattern", "popupPassKeys"];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      field = _ref[_i];
      _ref1 = ["input", "change"];
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        event = _ref1[_j];
        document.getElementById(field).addEventListener(event, onChange, false);
      }
    }
    return reset(true);
  });

}).call(this);
